 ; Ŀ
 ;   Dg - explode all groups to which a selected entity belongs.           
 ;   Copyright 1999 by Rocket Software                                     
 ;   A more modern terminology would have been "Band".                     
 ; 

 ; Ŀ
 ;   Nert - error handler.                                                 
 ; 
 (DEFUN NERT (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
  (setvar "snapmode" snapp)
 (princ))
 ; Ŀ
 ;   Nert end.                                                             
 ; 

 ; Ŀ
 ;   Grrr - get group data for an entity.                                  
 ;   Argument: Enam - the entity name.                                     
 ;   Returns a list of lists: ((group_name member_ename ...) ...)          
 ;   or nil if the entity wasn't a member of any groups.                   
 ;                                                                         
 ;   Note that a group can't contain other groups as such - including one  
 ;   group in another adds its members.                                    
 ; 
 (DEFUN GRRR (enam / entt grlist master mast2)
  (setq entt (entget enam))
 ; Ŀ
 ;   There will be one 330 group in the entity data for each group to      
 ;   which the object belongs.  Note that an entity can belong to          
 ;   multiple groups.  So get a list of their enames.                      
 ;   Also: check to see if this really is a group and not some other type  
 ;   of reactor.  (The 0 group in the entity data for the 330 group in     
 ;   the original entity is (0 . "GROUP"))                                 
 ; 
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (and (= (car sub) 330)
                  (= (cdr (assoc 0 (entget (cdr sub)))) "GROUP"))
             (setq grlist (cons (cdr sub) grlist)))
         (setq num (1+ num)))
 ; Ŀ
 ;   If any of the 330 enames were Groups, add the enames of the entities  
 ;   contained in each group to the appropriate sublist.                   
 ; 
  (if grlist
      (progn
           (setq num 0)
           (while (setq grenam (nth num grlist))
                  (setq subent (entget grenam))
                  (setq newlst (list grenam))
                  (setq subnum 0)
                  (while (setq sub (nth subnum subent))
                         (if (= (car sub) 340)
                             (setq newlst (append newlst (list (cdr sub)))))
                         (setq subnum (1+ subnum)))
                  (setq master (cons newlst master))
                  (setq num (1+ num)))
 ; Ŀ
 ;   Add the group name of each group to the start of its sublist.         
 ;   First get a copy of the master group list.                            
 ; 
           (setq grdict (dictsearch (namedobjdict) "acad_group"))
           (setq grnams (reverse grdict))
 ; Ŀ
 ;   Get the name for each group from the list.                            
 ; 
           (setq num 0)
           (while (setq sub (nth num master))
                  (setq grenam (car sub))
                  (setq grpnam (cadr (member (cons 350 grenam) grnams)))
                  (setq sub (cons (cdr grpnam) sub))
                  (setq mast2 (cons sub mast2))
                  (setq num (1+ num)))))
 mast2)
 ; Ŀ
 ;   Grrr end.                                                             
 ; 

 ; Ŀ
 ;   Dg.                                                                   
 ; 
 (DEFUN C:DG (/ esav snapp aa enam entt grdat sub gstr)
  (setq esav *error*)
  (setq *error* nert)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (if (setq enam (entsel "Select entity:\n"))
      (progn
           (setq entt (entget (setq enam (car enam)) (list "*")))
 ; Ŀ
 ;   If the entity belongs to any groups, get their names.                 
 ; 
           (if (assoc 330 entt)
               (progn
                    (setq gstr "Groups destroyed:")
                    (setq grdat (grrr enam))
                    (while (setq sub (car grdat))
                           (setq grdat (cdr grdat))
                           (setq gstr (strcat gstr " "
                                              (setq grnam (car sub)) ","))
                           (command ".-group" "explode" grnam))
                    (setq gstr (substr gstr 1 (1- (strlen gstr))))
                    (write-line (strcat gstr "."))))))
  (setvar "snapmode" snapp)
  (setq *error* esav)
 (princ))